#!/usr/bin/perl -w
use strict;

use Test::More;

use Bookmark;

subtest 'Basic bookmark' => sub {
    my $time_1 = time - 30;
    my $time_2 = time;
    my $bookmark = Bookmark->new({
        id => 1,
        uri => 'http://metacpan.org',
        title => 'My Bookmark',
        ctime => $time_1,
        mtime => $time_2,
        tags => [qw{test}],
    });

    is($bookmark->id, 1, 'id set okay');
    is($bookmark->uri, 'http://metacpan.org', 'uri set okay');
    is($bookmark->title, 'My Bookmark', 'title set okay');
    is($bookmark->ctime, $time_1, 'ctime set okay');
    is($bookmark->mtime, $time_2, 'mtime set okay');
    is_deeply($bookmark->tags, [qw{test}], 'tags set okay');
};

subtest 'Implicit mtime' => sub {
    my $time = time;
    my $bookmark = Bookmark->new({
        id => 1,
        uri => 'http://metacpan.org',
        title => 'My Bookmark',
        ctime => $time,
        tags => [qw{test}],
    });

    is($bookmark->mtime, $time, 'implicit mtime set okay');
};

done_testing();
