#!/usr/bin/perl -w
use strict;

use YAML;
use Plack::Builder;

use BookmarkApp::Dispatch;

-e 'conf.yml' or die "Missing required conf.yml config file\n";

my $config = YAML::LoadFile('conf.yml');
my $app = BookmarkApp::Dispatch->as_psgi(
    args_to_new => {
        PARAMS => { dbname => $config->{dbname} },
    },
);

builder {
    enable_if { $_[0]->{REMOTE_ADDR} eq $config->{proxy_ip} } 'ReverseProxy';
    enable_if { $_[0]->{REQUEST_METHOD} ne 'GET' } 'Auth::Digest', (
        realm           => 'Bookmarks',
        secret          => 'blahblahblah', #TODO: change this!
        password_hashed => 1,
        authenticator   => sub { $config->{digest_password} }
    );
    $app;
};
