#!/usr/bin/perl -w
use strict;

package BookmarkApp::Dispatch;
use base 'CGI::Application::Dispatch::PSGI';

sub dispatch_args {
    return {
        table => [
            '[get]'           => { app => 'BookmarkApp', rm => 'list' },
            'list[get]'       => { app => 'BookmarkApp', rm => 'list' },
            'feed[get]'       => { app => 'BookmarkApp', rm => 'feed' },
            ':id[get]'        => { app => 'BookmarkApp', rm => 'view' },
            ':id/:field[get]' => { app => 'BookmarkApp', rm => 'view_field' },
            '[post]'          => { app => 'BookmarkApp', rm => 'create' },
            ':id[post]'       => { app => 'BookmarkApp', rm => 'edit' },
        ],
    };
}

# module return
1;
