#!/usr/bin/perl -w
use strict;

package BookmarkApp::Dispatch;
use base 'CGI::Application::Dispatch';

sub dispatch_args {
    return {
        table => [
            '[get]'           => { app => 'BookmarkApp', rm => 'list' },
            'list[get]'       => { app => 'BookmarkApp', rm => 'list' },
            'feed[get]'       => { app => 'BookmarkApp', rm => 'feed' },
            ':id[get]'        => { app => 'BookmarkApp', rm => 'view' },
            ':id/:field[get]' => { app => 'BookmarkApp', rm => 'view_field' },
            ':id?[post]'      => { app => 'BookmarkApp', rm => 'edit' },
        ],
    };
}

package main;
# check for whether we are behind a reverse proxy, and adjust the SERVER_NAME accordingly
# TODO: use something like Plack::Middlware::ReverseProxy instead
$ENV{SERVER_NAME} = $ENV{HTTP_X_FORWARDED_HOST} if $ENV{HTTP_X_FORWARDED_HOST};

BookmarkApp::Dispatch->dispatch(
    args_to_new => {
        #TODO: dbname should be in a config file
        PARAMS => { dbname => 'fk.db' },
    }
);
