package DiscFlacFile;

use Moose;

use Audio::FLAC::Header;
use Tracks;

has file => (
    is  => 'ro',
    isa => 'Str',
);
has flac => (
    is       => 'ro',
    isa      => 'Audio::FLAC::Header',
    builder  => '_load_flac',
    lazy     => 1,
    init_arg => undef,
);
has tracks => (
    is       => 'ro',
    isa      => 'Tracks',
    builder  => '_load_tracks',
    lazy     => 1,
    init_arg => undef,
);

sub _load_flac { Audio::FLAC::Header->new($_[0]->file) }

sub _load_tracks {
    my $self = shift;
    my $tracks = Tracks->new;
    $tracks->read_flac($self->flac);
    return $tracks;
}

sub discid {
    my $self = shift;
    return $self->flac->tags('MUSICBRAINZ_DISCID') || $self->tracks->discid;
}

sub barcode {
    my $self = shift;
    return $self->flac->tags('BARCODE');
}

# module return
1;
