package Bookmark;

use Moose;

has id    => ( is => 'rw' );
has uri   => ( is => 'rw' );
has title => ( is => 'rw' );
has ctime => ( is => 'rw' );
has mtime => ( is => 'rw' );
has tags  => ( is => 'rw' );
has bookmark_uri => ( is => 'rw' );

sub BUILD {
    my $self = shift;
    my $args = shift;
    if ($args->{base_uri}) {
        $self->bookmark_uri(URI->new_abs($self->id, $args->{base_uri}));
    }
}

sub TO_JSON {
    my $self = shift;
    return {
        id    => $self->id,
        uri   => $self->uri,
        title => $self->title,
        ctime => $self->ctime,
        mtime => $self->mtime,
        tags  => $self->tags,
        ($self->bookmark_uri ? (bookmark_uri => $self->bookmark_uri->canonical->as_string) : ()),
    };
}

# module return
1;
